% Test header
function tests = hyCPN1Test
    tests = functiontests(localfunctions);
end

function hyCPN1ConstructTest(testCase)
H = hyCPN1();
verifyEmpty(testCase, H.F.state.c);

H.F.state = [0 0 1 0 0 0 0 0 0 1 0 0 0;...
    0 1 0 0 0 1 0 0 0 0 0 0 0;...
    0 0 0 0 0 0 0 0 0 0 1 0 0];
H.F.stateDerivative = [1 0 0 0 0 0 0 0 0 0 0 0 0;...
    0 0 0 1 0 0 0 0 0 0 0 0 0;...
    0 0 0 0 0 0 0 0 0 0 0 1 1];
H.F.algebraic = [0 0 0 0 0 0 1 0 0 0 0 0 0;...
    0 0 0 0 0 0 0 1 0 0 0 0 0];
H.F.boolean = [0 0 0 0 1 0 0 0 2 2 0 0 0];
H.F.input = [0 1 0 0 0 0 0 0 0 0 0 0 0;...
    0 0 1 0 0 0 0 0 0 0 0 0 0;...
    0 0 0 0 0 0 0 0 1 0 0 0 0];

H.phi.equality = [1 -0.13  0.13 0 0 0 0 0 0 0 0 0 0;...
    0 0 0 1 0 0 0 0 0 0 -1 0 0;...
    0 0 0 0 -1/1 1/1 0 0 0 0 15 0.5 0.5;...
    0 -1 0 0 0 0 1 0 0 0 0 0 0;...
    0 -1 0 0 0 0 1 0 0 0 0 0 0;...
    0 0 -1 0 0 0 0 1 0 0 0 0 0];
H.phi.inequality = [0 0 0 0 0 0 0 0 -1 1 0 0 0;...
    0 0 -1 0 0 0 0 1 0 0 0 0 0];

verifyEqual(testCase, H.F.algebraic.t(1,7), sparse(true));
end

